﻿using Foundation;
using UIKit;
using Microsoft.Maui.Embedding;
using Microsoft.Maui.Platform;
using Syncfusion.Maui.Core;
using Syncfusion.Maui.Core.Hosting;
using CoreGraphics;

namespace TestAvatarIOS;

[Register ("AppDelegate")]
public class AppDelegate : UIApplicationDelegate
{
    MauiContext? _mauiContext;

    public override UIWindow? Window {
		get;
		set;
	}

	public override bool FinishedLaunching (UIApplication application, NSDictionary launchOptions)
	{
        // create a new window instance based on the screen size
        Window = new UIWindow(UIScreen.MainScreen.Bounds);

        MauiAppBuilder builder = MauiApp.CreateBuilder();
        builder.UseMauiEmbedding<Microsoft.Maui.Controls.Application>();
        builder.ConfigureSyncfusionCore();
		builder.Services.Add(new Microsoft.Extensions.DependencyInjection.ServiceDescriptor(typeof(UIWindow), Window));

		MauiApp mauiApp = builder.Build();
		_mauiContext = new MauiContext(mauiApp.Services);


        var vc = new UIViewController();


        SfBusyIndicator sf = new SfBusyIndicator
        {
            IsRunning = true,
            BackgroundColor = Microsoft.Maui.Graphics.Colors.Green,


        };

        var sfView = sf.ToPlatform(_mauiContext);
        sfView.Frame = Window!.Frame;
        vc.View!.AddSubview(sfView);
        Window.RootViewController = vc;
        Window.MakeKeyAndVisible();

        return true;

       
    }
}

